function varargout = ModelFitGUIOff(varargin)
% MODELFITGUI_OFF MATLAB code for ModelFitGUI_Off.fig
%      MODELFITGUI_OFF, by itself, creates a new MODELFITGUI_OFF or raises the existing
%      singleton*.
%
%      H = MODELFITGUI_OFF returns the handle to a new MODELFITGUI_OFF or the handle to
%      the existing singleton*.
%
%      MODELFITGUI_OFF('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MODELFITGUI_OFF.M with the given input arguments.
%
%      MODELFITGUI_OFF('Property','Value',...) creates a new MODELFITGUI_OFF or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before ModelFitGUI_Off_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to ModelFitGUI_Off_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help ModelFitGUI_Off

% Last Modified by GUIDE v2.5 31-Jan-2019 17:31:02

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @ModelFitGUI_Off_OpeningFcn, ...
                   'gui_OutputFcn',  @ModelFitGUI_Off_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before ModelFitGUI_Off is made visible.
function ModelFitGUI_Off_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ModelFitGUI_Off (see VARARGIN)

% Choose default command line output for ModelFitGUI_Off
handles.output = hObject;
handles.savepath = 'PATH-TO-OUTPUT';
handles.modelcols = 'br';

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ModelFitGUI_Off wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = ModelFitGUI_Off_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



%------------------------------------------------------------------------%
% Object Creation

function listbox_mouse_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','red');
end

function listbox_chan_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function listbox_model_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p1_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p2_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p3_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p4_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p5_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p6_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%------------------------------------------------------------------------%
% Object Callback

% List: Mice
function listbox_mouse_Callback(hObject, ~, handles)
i = hObject.Value;
mouse = hObject.String{i};

switch mouse
	case 'Ba' 
    	channels = {[1:12,0,-1]};
	case 'Le'
    	channels = {[1:16,0,-1]};
	case 'Ni'
    	channels = {[1:10,0,-1]};
	case 'No'
    	channels = {[1:9,0,-1]};
	case 'Th'
    	channels = {[1:12,0,-1]}; 
    case 'Za'
    	channels = {[1:16,0,-1]}; 
end

handles.model.mouse = mouse;
handles.listbox_chan.String = channels;
handles.listbox_chan.Enable = 'on';
guidata(hObject,handles)

% List: Channels
function listbox_chan_Callback(hObject, ~, handles)
i = hObject.Value;
chan = str2num(hObject.String{i});
handles.model.chan = chan;
handles.pushbutton_load.Enable = 'on';
guidata(hObject,handles)

% List: Models
function listbox_model_Callback(hObject, ~, handles)
modelType = hObject.Value;
handles.model.type = modelType;

handles.pushbutton_loadparms.Enable = 'on';
handles.pushbutton_default.Enable = 'on';
handles.pushbutton_optimise.Enable = 'on';
handles.pushbutton_save.Enable = 'on';
handles.pushbutton_savefig.Enable = 'on';
handles.pushbutton_resetplot.Enable = 'on';

guidata(hObject,handles)


% Button: Load Data for Off model
function pushbutton_load_Callback(hObject, ~, handles)
busyLightOn(hObject,handles)

mouse = handles.model.mouse;
chan = handles.model.chan;

[W, N, R, A] = loadWNRA(mouse);

if chan == -1
    Chns = handles.listbox_chan.String;
    nCh = length(Chns)-2;
    offocc = zeros(nCh, 43200);
    fr = zeros(nCh, 43200);
    for i=1:nCh
        ch = str2num(Chns{i});
        LFP = loadLFP(mouse, ch);
        [filtb,filta] = butter(4, [0.5,6]/(256/2));
        fLFP = filtfilt(filtb, filta, LFP);
        [fr(i,:), SpkBin] = loadFR(mouse, ch);
        [AmpThresh, ISIThresh] = findAmpThresh(fLFP, SpkBin);
        [offocc(i,:),~,~,~] = offdetection(fLFP, SpkBin, AmpThresh, ISIThresh);
    end
    OffOcc = mean(offocc);
    medOff = medianBoutNREM(OffOcc, N, A);
    FR = mean(fr);
else
    
    LFP = loadLFP(mouse, chan);
    [filtb,filta] = butter(4, [0.5,6]/(256/2));
    fLFP = filtfilt(filtb, filta, LFP);
    [FR, SpkBin] = loadFR(mouse, chan);
    [AmpThresh, ISIThresh] = findAmpThresh(fLFP, SpkBin);
    [OffOcc,~,~,~] = offdetection(fLFP, SpkBin, AmpThresh, ISIThresh);
    medOff = medianBoutNREM(OffOcc, N, A);
end

handles.model.OffOcc = OffOcc;
handles.model.WNRA = vertcat(W,N,R,A);
handles.model.medOff = medOff;
handles.model.FR = FR;
handles.model.AmpThresh = AmpThresh;
handles.model.ISIThresh = ISIThresh;

handles.listbox_model.Enable = 'on';

plotModel(handles)
plotSavedS(handles)

busyLightOff(hObject,handles)

% Load Previously Saved Parameters
function pushbutton_loadparms_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
modelType = handles.model.type;

parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(modelType),'.mat'];
load(parmfilename, 'parms')
handles.model.parms = parms;

guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)


% Button: Set Default Parameters
function pushbutton_default_Callback(hObject, ~, handles)
modelType = handles.model.type;

parms = [];
switch modelType
    case 1
	parms(1) = 2e-4;   % Alpha
    parms(2) = 2e-4;   % Beta
	parms(3) = 20;     % S0
    parms(4) = 30;     % Smax
    parms(5) = 10;     % Smin
    case 2
	parms(1) = 2e-5;   % Alpha
    parms(2) = 2e-5;   % Beta
	parms(3) = 20;     % S0
    parms(4) = 30;     % Smax
    parms(5) = 10;     % Smin
end
handles.model.parms = parms;

guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)

% Button: Optimise Parameters
function pushbutton_optimise_Callback(hObject, ~, handles)
busyLightOn(hObject,handles)

modelType = handles.model.type;
FR = handles.model.FR;
medOff = handles.model.medOff;
OffOcc = handles.model.OffOcc;
N = handles.model.WNRA(2,:);
A = handles.model.WNRA(4,:);

switch modelType 
    case 1  
    try
        parms0 = handles.model.parms;
    catch
        parms0 = [2e-4,2e-4,20,100,0];
    end
    fun = @(x)optimiseFun_Classic(x, medOff, N, A);
    opt.MaxFunEvals = 1000*5;
    opt.MaxIter = 1000*5;
    parms = fminsearch(fun, parms0, opt);
    
    case 2
	try
        parms0 = handles.model.parms;
    catch
        parms0 = [2e-6,2e-6,20,100,0];
    end
    fun = @(x)optimiseFun_OFF(x, FR, OffOcc, medOff, N, A);
    opt.MaxFunEvals = 1000*5;
    opt.MaxIter = 1000*5;
    parms = fminsearch(fun, parms0, opt);
end
handles.model.parms = parms;

busyLightOff(hObject,handles)
guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)


% Button: Reset Plot
function pushbutton_resetplot_Callback(hObject, ~, handles)
plotModel(handles)
plotSavedS(handles)
plotAddS(handles)

% Button: Save Parameters
function pushbutton_save_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
modelType = handles.model.type;
parms = handles.model.parms;
S = handles.model.S;
error = handles.model.error;
errorMetric = handles.model.errorMetric;
AmpThresh = handles.model.AmpThresh;
ISIThresh = handles.model.ISIThresh;

parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(modelType),'.mat'];
save(parmfilename, 'parms', 'S', 'error', 'errorMetric', 'AmpThresh', 'ISIThresh')

% Button: Save Figure
function pushbutton_savefig_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;

fig = figure('Position', [100,100,1500,800], 'Visible','off');
ax = copyobj(handles.figure, fig);
set(ax(1),'Position',[30,10,250,45])
figfilename = [handles.savepath, mouse,'-ch',int2str(chan),'.jpg'];
saveas(fig, figfilename)


%--------------------------%
% Button: Increase Parameter 1
function pushbutton_p1inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 1)

% Button: Decrease Parameter 1
function pushbutton_p1dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 2)

% Edit: Parameter 1
function edit_p1_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 3)

% Button: Increase Parameter 2
function pushbutton_p2inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 1)

% Button: Decrease Parameter 2
function pushbutton_p2dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 2)

% Edit: Parameter 2
function edit_p2_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 3)

% Button: Increase Parameter 3
function pushbutton_p3inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 1)

% Button: Decrease Parameter 3
function pushbutton_p3dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 2)

% Edit: Parameter 3
function edit_p3_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 3)

% Button: Increase Parameter 4
function pushbutton_p4inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 1)

% Button: Decrease Parameter 4
function pushbutton_p4dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 2)

% Edit: Parameter 4
function edit_p4_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 3)

% Button: Increase Parameter 5
function pushbutton_p5inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 1)

% Button: Decrease Parameter 5
function pushbutton_p5dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 2)

% Edit: Parameter 5
function edit_p5_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 3)

% Button: Increase Parameter 6
function pushbutton_p6inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 1)

% Button: Decrease Parameter 6
function pushbutton_p6dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 2)

% Edit: Parameter 6
function edit_p6_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 3)

%------------------------------------------------------------------------%
% Model Functions
function calculateProcessS(hObject, handles)
modelType = handles.model.type;
FR = handles.model.FR;
OffOcc = handles.model.OffOcc;
Tmax = 43200;

switch modelType
    % Classic Model    
    case 1
        N = handles.model.WNRA(2,:);
        alpha = handles.model.parms(1);
        beta = handles.model.parms(2);
        S0 = handles.model.parms(3);
        Smax = handles.model.parms(4);
        Smin = handles.model.parms(5); 
        
        S = zeros(1,Tmax);
        S(1) = S0;
        for t=2:Tmax    
            if N(t)==0
                dSdt = alpha*(Smax - S(t-1)); 
            else 
                dSdt = beta*(Smin - S(t-1));
            end
            S(t) = S(t-1) + dSdt;
        end
    % Threshold Model    
    case 2
        alpha = handles.model.parms(1);
        beta = handles.model.parms(2);
        S0 = handles.model.parms(3);
        Smax = handles.model.parms(4);
        Smin = handles.model.parms(5);        
        
        S = zeros(1,Tmax);
        S(1) = S0;
        for t=2:Tmax
            dSdt = alpha*FR(t)*(Smax - S(t-1)) - beta*(S(t-1) - Smin)*OffOcc(t); 
            S(t) = S(t-1) + dSdt;
        end
end

% Error
medOff = handles.model.medOff;
WNRA = handles.model.WNRA;
N = handles.model.WNRA(2,:);
A = handles.model.WNRA(4,:);
[medProcS, durN] = medianBoutNREM(S, N, A);
durN(durN<=15) =[];
w = durN/sum(durN);
errorMetric = sum(abs(medOff(:,2) - medProcS(:,2)) .*w');
error = median(abs(medOff(:,2) - medProcS(:,2))./medOff(:,2)) *100;

handles.model.S = S;
handles.model.error = error;
handles.model.errorMetric = errorMetric;
guidata(hObject,handles)
plotAddS(handles)


function plotModel(handles)
W = handles.model.WNRA(1,:);
N = handles.model.WNRA(2,:);
R = handles.model.WNRA(3,:);
cols = handles.modelcols;
OffOcc = handles.model.OffOcc;
medOff = handles.model.medOff;

axes(handles.figure)
cla
hold on
plot(OffOcc, 'Color', [0.8,0.8,0.8]);
bar(medOff(:,1),medOff(:,2), 'k','barwidth',1);
bar(W,'FaceColor','g','EdgeColor','g')
bar(N,'FaceColor','b','EdgeColor','b')
bar(R,'FaceColor','r','EdgeColor','r')
xlabel('Time (hrs)')
ylabel('MUA (Hz), Off Occ (%), Process S')
set(gca,'XTick', 0:2700:43200)
set(gca,'XTickLabels', 0:3:48)
set(gca,'fontsize',18)
ylim([0,100])


function plotSavedS(handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
cols = handles.modelcols;
for m=1:2
    try 
        parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(m),'.mat'];
        load(parmfilename, 'S')
        plot(S,cols(m), 'LineWidth',1.5);
    catch
        continue
    end
end

function plotAddS(handles)
S = handles.model.S;
m = handles.model.type;
cols = handles.modelcols; 
axes(handles.figure)
plot(S,'Color',cols(m))

%------------------------------------------------------------------------%
% Misc Utils
function activateAdjParms(hObject,handles)
modelType = handles.model.type;

handles.edit_p1.Enable = 'on'; handles.pushbutton_p1dec.Enable = 'on';
handles.edit_p2.Enable = 'on'; handles.pushbutton_p2dec.Enable = 'on';
handles.edit_p3.Enable = 'on'; handles.pushbutton_p3dec.Enable = 'on';
handles.edit_p4.Enable = 'on'; handles.pushbutton_p4dec.Enable = 'on';
handles.edit_p5.Enable = 'on'; handles.pushbutton_p5dec.Enable = 'on';
handles.text_p1.Enable = 'on'; handles.pushbutton_p1inc.Enable = 'on';
handles.text_p2.Enable = 'on'; handles.pushbutton_p2inc.Enable = 'on';
handles.text_p3.Enable = 'on'; handles.pushbutton_p3inc.Enable = 'on';
handles.text_p4.Enable = 'on'; handles.pushbutton_p4inc.Enable = 'on';
handles.text_p5.Enable = 'on'; handles.pushbutton_p5inc.Enable = 'on';

guidata(hObject,handles)


function updateEditBoxes(hObject, handles)
handles.edit_p1.String = num2str(handles.model.parms(1));
handles.edit_p2.String = num2str(handles.model.parms(2));
handles.edit_p3.String = num2str(handles.model.parms(3));
handles.edit_p4.String = num2str(handles.model.parms(4));
handles.edit_p5.String = num2str(handles.model.parms(5));
   
guidata(hObject,handles)

function changeParms(hObject,handles, p, type)
switch type
    case 1
        handles.model.parms(p) = handles.model.parms(p) * 1.1;
    case 2
        handles.model.parms(p) = handles.model.parms(p) * 0.9;
    case 3
        prms(1) = str2double(handles.edit_p1.String);
        prms(2) = str2double(handles.edit_p2.String);
        prms(3) = str2double(handles.edit_p3.String);
        prms(4) = str2double(handles.edit_p4.String);
        prms(5) = str2double(handles.edit_p5.String);
        handles.model.parms(p) = prms(p);
end

guidata(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)

function busyLightOn(hObject,handles)
handles.BusyLight.BackgroundColor = 'r'; 
pause(0.1)
guidata(hObject,handles)

function busyLightOff(hObject,handles)
handles.BusyLight.BackgroundColor = [0.65,0.65,0.65]; 
guidata(hObject,handles)
